#ifndef __App_h__
#define __App_h__

#include <lib3d/App/BaseApp.h>
#include <lib3d/util2d/Particle.h>
#include <time.h>

#include "HighResTimer.h"
#include "TerrainManager.h"
#include "TerrainLoader.h"
#include "Player.h"
#include "Projectile.h"
#include "EffectsManager.h"
#include "InterfaceManager.h"
#include "ConfigManager.h"
#include "SoundManager.h"
#include "Bonus.h"
#include "keymap.h"

#include <list>
using namespace std;

#define UP_TIME_THRESHOLD 0.3

typedef list<Projectile*> ProjList;
typedef list<Bonus*> BonusList;


//--------------------------------------------------------

class App : public BaseApp, UIOwner {

public:

   enum eGameState { GS_MENU=0, GS_LISTEN, GS_CONNECTING, GS_PLAY, GS_GAMEOVER };

   void preInit() {
      SDL_GL_SetAttribute(SDL_GL_STENCIL_SIZE,1);
   }

   void onInit();
   void onKeyPressed(const SDLKey &key);
   void onMouseButtonPressed(int button,int scrx,int scry);
   void onKeyReleased(const SDLKey &key);
   void onRender();
   void onExit() { sound.destroy(); }

   void UIEvent_Callback(UIEvent *event);  

   void setDefaultMap(const char *s) { strcpy(defmap,s); use_defmap = true; }
      
   int winw,winh;

private:

   void setupUI();
   void renderTerrain(float shiftx,float shifty);
   void renderCPanel();
   void movePlayer(Player *p,float dist);
   void turnTurret(Player *p,float dir);
   void changeMap();
   void startGame();
   void say(int pid,const char *message);
   void launchProjectile(Player *p,float dx,float dy);
   void spawnRandomBonus();
   void debugMessage(const char *format,...);
   void initQuotes();
   void randomQuote();
   void setState(eGameState st) { gstate = st; };
   eGameState getState() { return gstate; };

   HighResTimer timer;
   TerrainManager *tman;
   EffectsManager *effman;
   InterfaceManager *iman;
   SoundManager sound;
   Player player[2];
   Player *winner;
   ProjList  projectiles;
   BonusList bonuses;
   int pointerx,pointery;
   eGameState gstate;
   double timet;
   double dElapsed;
   bool use_defmap;

   Texture *lifebar[2];
   Texture *emptylifebar;
   Texture *panel[2];
   Texture *circle;
   Texture *logo;
   char defmap[256];
   
   bool   left_pressed[2],right_pressed[2],up_pressed[2],down_pressed[2],fire_pressed[2];
   double p1_up_time,p2_up_time;
   bool   chat_mode;
   char   incomingChat[2][256];
   vector<string> quotes;


};

#endif